#ifndef __InterfaceManager_h__
#define __InterfaceManager_h__

#pragma warning (disable : 4786)

#include <list>
#include <string>
using namespace std;

#include "UI.h"

class InterfaceManager {

public:

   void init(UIOwner *owner);
   
   void debugMessage(const char *buffer);
   void updateScores(int p1scr,int p2scr);
   void updateChatMessages(float x1,float y1,const char *p1msg,
      float x2,float y2,const char *p2msg);
   void beginChatText();
   void endChatText();
   const char *getChatText() { return chatText; };
   const char *getIp() { return ipEdit->getText(); };
   void toggleMainMenu();
   bool isMenuVisible() { return mainMenu->isVisible(); }
   void activateMainMenu(bool a);
   void showIpPanel(bool s);
   void showCreditsPanel(bool s);
   void showInstPanel(bool s);
   void setMapName(const char *name) { mapNameLabel->setText(name); };
   void setHosts(list<string> &hosts);
   void setAmmo(int p1a,int p2a);
   bool isChatInputEdit(UIWidget *w) { return w == chatInputEdit; };
   bool isMainMenu(UIWidget *w) { return w == mainMenu; };
   bool isIpEdit(UIWidget *w) { return w == ipEdit; };
      
   void processKeyEvents(const SDLKey &key);
   void update(float dt);
   void render();
   
   static InterfaceManager* instance();

protected:
   UILabel *debugLabel;
   UILabel *scoreLabel[2];
   UILabel *shoutLabel;
   UILabel *chatLabel[2];
   UILabel *mapNameLabel;
   UILabel *oyorgLabel;
   UIEdit  *chatInputEdit;
   UIMenu  *mainMenu;
   UIPanel *ipPanel;
   MyUIPanel *creditsPanel;
   UILabel   *creditsLabel[8];
   MyUIPanel *instPanel;
   UILabel   *instLabel[8];
   UIEdit  *ipEdit;
   UIPanel *hostsPanel;
   UIMultiLineLabel  *hostsLabel;
   UILabel *hostsPanelCaption;
   UILabel *p1AmmoLabel;
   UILabel *p2AmmoLabel;

   float chatTimeout[2];
   char  chatText[256];

private:
   
   InterfaceManager();
   ~InterfaceManager();

   UIManager uiman;
   UIOwner   *owner;

};



#endif

